/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWDataField;
import filenet.vw.api.VWException;
import filenet.vw.api.VWInstructionElement;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQuery;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.api.VWWorkElement;
import filenet.vw.api.VWWorkObject;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.server.VWField;
import filenet.vw.server.VWWorkObjectID;
import java.io.Serializable;

public final class VWQueueElement
extends VWWorkElement
implements IVWtoXML,
Serializable {
    private static final long serialVersionUID = 7557L;
    public static final int LOCKED_BY_NONE = 0;
    public static final int LOCKED_BY_USER = 1;
    public static final int LOCKED_BY_SYSTEM = 2;
    public static final int DEADLINE_NOT_REACHED = 0;
    public static final int DEADLINE_REMINDER_NOTICE = 1;
    public static final int DEADLINE_REACHED = 2;
    public static final int COMPLETED = 3;
    public static final int DTSTRING = 0;
    public static final int DTINTEGER = 1;
    public static final int DTBOOLEAN = 2;
    protected static final int DTDOUBLE = 3;
    protected static final int DTTIME = 4;
    protected static final int FLAG_CAN_REASSIGN = 4;
    protected static final int FLAG_CAN_VIEW_STATUS = 8;
    protected static final int FLAG_CAN_VIEW_HISTORY = 16;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-02-22 22:06:45 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/1 $";
    }

    protected VWQueueElement(VWField[] fieldValues, VWWorkObjectID work_object_Id, VWQuery source) {
        super(fieldValues, work_object_Id, source);
    }

    public VWInstructionElement fetchInstructionElement(boolean lock, boolean overrideLock) throws VWException {
        VWInstructionElement resultObject = new VWInstructionElement(null, this.workObjectId, this.sourceQuery);
        resultObject.fetchFields(2, lock, overrideLock);
        if (null == resultObject.workObjectId) {
            return null;
        }
        return resultObject;
    }

    public VWWorkObject fetchWorkObject(boolean lock, boolean overrideLock) throws VWException {
        VWWorkObject resultObject = new VWWorkObject(null, this.workObjectId, this.sourceQuery);
        resultObject.fetchFields(1, lock, overrideLock);
        if (null == resultObject.workObjectId) {
            return null;
        }
        return resultObject;
    }

    public static String ConvertTagToName(String aTag, int aTagType) throws Exception {
        switch (aTagType) {
            case 0: {
                return aTag;
            }
            case 2: {
                String bresult = aTag.equals("T") ? "true" : "false";
                return bresult;
            }
            case 1: {
                Long lresult;
                try {
                    lresult = new Long(aTag);
                }
                catch (NumberFormatException e) {
                    throw new VWException("vw.api.VWQueueElementBadTag", "Tag parameter should represent an integer : {0} : {1}", aTag, new Integer(aTag.length()));
                }
                Long x = new Long(lresult + Integer.MIN_VALUE);
                return x.toString();
            }
        }
        throw new VWException("vw.api.QETagTypeInvalid", "ConvertNameToTag:Type not found");
    }

    public static String ConvertNameToTag(String aWorkObjectName, int aTagType) throws Exception {
        switch (aTagType) {
            case 0: {
                return aWorkObjectName;
            }
            case 1: {
                Long num;
                try {
                    num = new Long(aWorkObjectName);
                }
                catch (NumberFormatException e) {
                    throw new VWException("vw.api.VWQueueElementBadWorkObjectName", "WorkObjectName parameter should represent an integer : {0} : {1}", aWorkObjectName, new Integer(aWorkObjectName.length()));
                }
                Long lresult = new Long(num - Integer.MIN_VALUE);
                return lresult.toString();
            }
            case 2: {
                String bresult = aWorkObjectName.equals("true") ? "T" : "F";
                return bresult;
            }
        }
        throw new VWException("vw.api.QETagTypeInvalid2", "ConvertNameToTag:Type not found");
    }

    public String[] getFieldNames() {
        return super.getFieldNames();
    }

    public String[] getAuthoredFieldNames() {
        return super.getAuthoredFieldNames();
    }

    public String[] getSystemDefinedFieldNames() {
        return super.getFilteredFieldNames(true);
    }

    public String[] getUserDefinedFieldNames() {
        return super.getFilteredFieldNames(false);
    }

    public Object getFieldValue(String fieldName) throws VWException {
        return super.getFieldValue(fieldName);
    }

    public boolean isSystemField(String fieldName) throws VWException {
        return super.isSystemField(fieldName);
    }

    public boolean hasFieldName(String fieldName) throws VWException {
        return super.hasFieldName(fieldName);
    }

    public String getWorkObjectName() throws VWException {
        return super.getWorkObjectName();
    }

    public String getWorkObjectNumber() throws VWException {
        return super.getWorkObjectNumber();
    }

    public String getTag() throws VWException {
        return super.getTag();
    }

    public String getWorkClassName() throws VWException {
        return super.getWorkClassName();
    }

    public String getWorkflowName() throws VWException {
        return super.getWorkClassName();
    }

    public String getWorkPerformerClassName() throws VWException {
        return super.getWorkPerformerClassName();
    }

    public String getQueueName() throws VWException {
        return super.getWorkPerformerClassName();
    }

    public String getOperationName() throws VWException {
        return super.getOperationName();
    }

    public String getStepName() throws VWException {
        return super.getStepName();
    }

    public String getAuthoredStepName() throws VWException {
        return super.getAuthoredStepName();
    }

    public String getInstructionSheetName() throws VWException {
        return super.getInstructionSheetName();
    }

    public String getLockedUser() throws VWException {
        return super.getLockedUser();
    }

    public VWParticipant getLockedUserPx() throws VWException {
        return super.getLockedUserPx();
    }

    public int getLockedStatus() throws VWException {
        Object tmpval = this.getFieldValue("F_Locked", true);
        if (tmpval instanceof Integer) {
            return (Integer)tmpval;
        }
        return 0;
    }

    public int getLockedMachine() throws VWException {
        Object tmpval = this.getFieldValue("F_LockMachine", true);
        if (tmpval instanceof Integer) {
            return (Integer)tmpval;
        }
        return 0;
    }

    public String toString() {
        String name = null;
        try {
            name = this.getWorkObjectName();
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return name;
    }

    public VWStepElement fetchStepElement(boolean lock, boolean overrideLock) throws VWException {
        VWStepElement resultObject = new VWStepElement(null, this.workObjectId, this.sourceQuery);
        resultObject.fetchFields(5, lock, overrideLock);
        if (null == resultObject.workObjectId) {
            return null;
        }
        return resultObject;
    }

    public String getMapName() throws VWException {
        return super.getInstructionSheetName();
    }

    public VWDataField[] getDataFields() throws VWException {
        VWDataField[] names = super.getDataFields();
        VWDataField[] results = null;
        int cnt = 0;
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                if (names[i] == null) continue;
                ++cnt;
            }
            if (names.length != cnt) {
                results = new VWDataField[cnt];
                int j = 0;
                for (int i = 0; i < names.length; ++i) {
                    if (names[i] == null) continue;
                    results[j] = names[i];
                    ++j;
                }
            } else {
                results = names;
            }
        }
        return results;
    }

    public VWDataField getDataField(String name) throws VWException {
        return super.getDataField(name);
    }

    public String getSelectedResponse() throws VWException {
        String value = super.getResponse();
        if (value != null) {
            return value;
        }
        return super.getSelectedResponse();
    }

    public String getSubject() throws VWException {
        return super.getSubject();
    }

    public int getStepDeadlineStatus() throws VWException {
        return super.getOverdue();
    }

    public boolean getCanReassign() throws VWException {
        int flag = super.getUIFlag();
        return (flag & 4) == 4;
    }

    public VWParticipant getBoundUserPx() throws VWException {
        return super.getBoundUserPx();
    }

    public int getProcessorId() throws VWException {
        return super.getProcessorId();
    }

    public VWStepProcessorInfo fetchStepProcessorInfo() throws VWException {
        return super.fetchStepProcessorInfo();
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWQueueElementNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("<QueueElement");
        int opId = this.getProcessorId();
        if (opId > -1) {
            theBuffer.append("\n" + ATTRIB_INDENT + "StepProcessorId=\"" + String.valueOf(opId) + "\"");
        }
        theBuffer.append("\n" + ATTRIB_INDENT + "MapName=\"" + this.getMapName() + "\"");
        String tmpS = this.getStepName();
        if (tmpS != null) {
            theBuffer.append(ATTRIB_INDENT + "StepName=\"" + VWXMLHandler.toXMLString(tmpS) + "\"\n");
        }
        theBuffer.append(">\n");
        theBuffer.append("<Fields");
        VWDataField[] df = this.getDataFields();
        if (df != null) {
            theBuffer.append(">\n");
            int arrayCount = df.length;
            for (int i = 0; i < arrayCount; ++i) {
                df[i].toXML(theBuffer);
            }
            theBuffer.append("</Fields>\n");
        } else {
            theBuffer.append("/>\n");
        }
        VWStepProcessorInfo spInfo = this.fetchStepProcessorInfo();
        if (spInfo != null) {
            spInfo.toXML(theBuffer);
        }
        theBuffer.append("</QueueElement>\n");
    }
}

